package cn.com.duiba.activity.common.center.api.dto.happyclear;

import java.io.Serializable;
import java.util.List;

/**
 * @author: zhengjianhao
 * @date: 2019/10/10 10:35
 * @description: 消消乐活动配置
 *
 * 重要！！！：配置基本存在tb_big_text中（为什么存tb_big_text，找最初设计者），但因text字段大小限制，部分配置单独建表存
 */
public class HappyClearTotalDto implements Serializable {

    private static final long serialVersionUID = -762004882995068316L;

    //活动关闭状态
    private Boolean closeStatus;

    private Boolean publish;

    private String title;

    private String appId;

    private Long id;

    /**
     * 奖励信息，数量：6
     */
    private List<HappyClearAllDto> signReward;
    /**
     * 奖项信息，数量：1 * 1~10
     */
    private List<HappyClearAllDto> prizeOptions;

    /**
     * 邀请有礼配置，数量：0~3 * 1
     */
    private HappyClearInviteDto inviteInfo;

    /**
     * 开始公告广告位，数量：0~9
     */
    private HappyClearNoticeAdvertDto noticeAdvert;

    /**
     * 弹窗公告广告位，数量：0~50
     */
    private HappyClearPopupAdvertDto popupAdvert;

    /**
     * 地图页公告广告位，数量：0~1
     */
    private HappyClearMapAdvertDto mapAdvert;

    /**
     * 星星宝箱档位配置，数量：0~99 * 1~10
     *
     * 重要！！！：因text字段大小限制，该配置不存tb_big_text，单独建表存
     */
    private List<HappyClearStarBoxLevelDto> starBoxLevelList;

    /**
     * 首次通关奖励配置，数量：0~200 * 1~10
     *
     * 重要！！！：因text字段大小限制，该配置不存tb_big_text，单独建表存
     */
    private List<HappyClearLevelPassPrizeDto> levelPassPrizeList;

    /**
     * 回归奖励配置，数量：1 * 1~10
     */
    private HappyClearReturnPrizeDto returnPrize;

    /**
     * 幸运抽奖配置，数量：1 * 8
     */
    private HappyClearLuckyDrawDto luckyDraw;

    /**
     * 刮刮卡档位配置，数量：8 * 1
     */
    private HappyClearInviteDto scratchCardInfo;

    /**
     * 红包雨配置
     *
     * 重要！！！：因text字段大小限制，该配置中的 sessionList 不存tb_big_text，单独建表存
     */
    private HappyClearRedRainDto redRainInfo;

    /**
     * 红包炸弹配置
     *
     * 重要！！！：因text字段大小限制，该配置中的 degreeList 不存tb_big_text，单独建表存
     */
    private HappyClearRedBombDto redBombInfo;

    public Boolean getCloseStatus() {
        return closeStatus;
    }

    public void setCloseStatus(Boolean closeStatus) {
        this.closeStatus = closeStatus;
    }

    public Boolean getPublish() {
        return publish;
    }

    public void setPublish(Boolean publish) {
        this.publish = publish;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<HappyClearAllDto> getSignReward() {
        return signReward;
    }

    public void setSignReward(List<HappyClearAllDto> signReward) {
        this.signReward = signReward;
    }

    public List<HappyClearAllDto> getPrizeOptions() {
        return prizeOptions;
    }

    public void setPrizeOptions(List<HappyClearAllDto> prizeOptions) {
        this.prizeOptions = prizeOptions;
    }

    public HappyClearInviteDto getInviteInfo() {
        return inviteInfo;
    }

    public void setInviteInfo(HappyClearInviteDto inviteInfo) {
        this.inviteInfo = inviteInfo;
    }

    public HappyClearNoticeAdvertDto getNoticeAdvert() {
        return noticeAdvert;
    }

    public void setNoticeAdvert(HappyClearNoticeAdvertDto noticeAdvert) {
        this.noticeAdvert = noticeAdvert;
    }

    public HappyClearPopupAdvertDto getPopupAdvert() {
        return popupAdvert;
    }

    public void setPopupAdvert(HappyClearPopupAdvertDto popupAdvert) {
        this.popupAdvert = popupAdvert;
    }

    public HappyClearMapAdvertDto getMapAdvert() {
        return mapAdvert;
    }

    public void setMapAdvert(HappyClearMapAdvertDto mapAdvert) {
        this.mapAdvert = mapAdvert;
    }

    public List<HappyClearStarBoxLevelDto> getStarBoxLevelList() {
        return starBoxLevelList;
    }

    public void setStarBoxLevelList(List<HappyClearStarBoxLevelDto> starBoxLevelList) {
        this.starBoxLevelList = starBoxLevelList;
    }

    public List<HappyClearLevelPassPrizeDto> getLevelPassPrizeList() {
        return levelPassPrizeList;
    }

    public void setLevelPassPrizeList(List<HappyClearLevelPassPrizeDto> levelPassPrizeList) {
        this.levelPassPrizeList = levelPassPrizeList;
    }

    public HappyClearReturnPrizeDto getReturnPrize() {
        return returnPrize;
    }

    public void setReturnPrize(HappyClearReturnPrizeDto returnPrize) {
        this.returnPrize = returnPrize;
    }

    public HappyClearLuckyDrawDto getLuckyDraw() {
        return luckyDraw;
    }

    public void setLuckyDraw(HappyClearLuckyDrawDto luckyDraw) {
        this.luckyDraw = luckyDraw;
    }

    public HappyClearInviteDto getScratchCardInfo() {
        return scratchCardInfo;
    }

    public void setScratchCardInfo(HappyClearInviteDto scratchCardInfo) {
        this.scratchCardInfo = scratchCardInfo;
    }

    public HappyClearRedRainDto getRedRainInfo() {
        return redRainInfo;
    }

    public void setRedRainInfo(HappyClearRedRainDto redRainInfo) {
        this.redRainInfo = redRainInfo;
    }

    public HappyClearRedBombDto getRedBombInfo() {
        return redBombInfo;
    }

    public void setRedBombInfo(HappyClearRedBombDto redBombInfo) {
        this.redBombInfo = redBombInfo;
    }
}
