package cn.com.duiba.activity.common.center.api.enums;

import java.util.HashMap;
import java.util.Map;

public enum SubCurrencyTypeEnum {
    //默认都是支付宝
    ALIPAY(0, "支付宝现金"),
    WECHAT_RED_PACKET(1, "微信现金");

    private static Map<Integer, SubCurrencyTypeEnum> codeMap = new HashMap<>();

    static {
        for (SubCurrencyTypeEnum type : values()) {
            codeMap.put(type.getCode(), type);
        }
    }

    public static SubCurrencyTypeEnum getByCode(Integer code) {
        return codeMap.get(code);
    }

    private Integer code;
    private String desc;

    SubCurrencyTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
