package cn.com.duiba.activity.common.center.api.enums.asyntask;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by xiaoxuda on 2019/2/21.
 */
public enum AsynTaskTypeEnum {
    RedAccPeriodMark(1, "总帐户标记任务"),
    BrickMark(2, "搬砖活动标记任务");

    private static Map<Integer, AsynTaskTypeEnum> typeMap = new HashMap<>();
    static{
        for(AsynTaskTypeEnum type : values()){
            typeMap.put(type.getCode(), type);
        }
    }

    public static AsynTaskTypeEnum getByCode(Integer code){
        return typeMap.get(code);
    }

    private Integer code;

    private String desc;

    AsynTaskTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
