package cn.com.duiba.activity.common.center.api.remoteservice.generalrelation;

import cn.com.duiba.activity.common.center.api.dto.generalrelation.GeneralRelationDto;
import cn.com.duiba.activity.common.center.api.enums.generalrelation.GeneralRelationTypeEnum;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @Description: 通用关系表操作
 * @Author: fxr
 * @Date: 2019/3/20
 */
@AdvancedFeignClient
public interface RemoteGeneralRelationService {
    /**
     * 增加关系对
     *
     * @param dto
     * @return 关系对ID
     */
    long insert(GeneralRelationDto dto);

    /**
     * 删除所有relationType分类下与partyAid有关的关系数据
     *
     * @param relationType
     * @param partyAid
     * @return
     */
    int deleteByTypeAndPartyAid(GeneralRelationTypeEnum relationType, Long partyAid);

    /**
     * @param relationType
     * @param partyAid
     * @param partyBids
     * @return
     */
    int batchDeleteByTypeAndPartyAidAndPartyBids(GeneralRelationTypeEnum relationType, Long partyAid, List<Long> partyBids);

    /**
     * @param relationType
     * @param partyAid     可null
     * @param partyBid     可null
     * @return
     */
    List<GeneralRelationDto> findWithUniqueKey(GeneralRelationTypeEnum relationType, Long partyAid, Long partyBid);
}
