package cn.com.duiba.activity.common.center.api.remoteservice.openbs;

import cn.com.duiba.activity.common.center.api.dto.openbs.ActOpenbsSwitchConfigDto;
import cn.com.duiba.api.enums.ActivityUniformityTypeEnum;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;


@AdvancedFeignClient
public interface RemoteActOpenbsSwitchService {
    int openSwitch(Long actId, Integer actType);

    int closeSwitch(Long actId, Integer actType);

    ActOpenbsSwitchConfigDto getByActIdAndType(Long actId, Integer actType);

    List<ActOpenbsSwitchConfigDto> listByActIdsAndActType(List<Long> actIds, Integer actType);

    /**
     * 查询用户是否需要openbs拦截
     * @param actId
     * @param typeEnum
     * @param partnerUserId
     * @return
     */
    boolean blockThisUser(Long actId, ActivityUniformityTypeEnum typeEnum, String partnerUserId);

    /**
     * 用户参与拦截 - 直接抛出异常
     * @param actId
     * @param typeEnum
     * @param partnerUserId
     * @throws BizException
     */
    void joinBlockThisUser(Long actId, ActivityUniformityTypeEnum typeEnum, String partnerUserId) throws BizException;
}
