package cn.com.duiba.activity.common.center.api.remoteservice.sharecode.master;

import java.util.List;

import cn.com.duiba.activity.common.center.api.dto.sharecode.MasterDiscipleDto;
import cn.com.duiba.activity.common.center.api.params.MasterBonusParam;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.api.bo.page.Page;

/**
 * @author zhangruofan
 * @date 2018/04/18
 */
@AdvancedFeignClient
public interface RemoteMasterDiscipleService {
    /**
     * 新增师徒关系
     * @param masterDiscipleDto 师徒关系参数
     * @return key
     * @throws BizException bizException
     */
    Long insert(MasterDiscipleDto masterDiscipleDto) throws BizException;

    /**
     * 查询徒弟列表
     * @param masterId 师傅id
     * @return 师徒关系列表
     * @throws BizException bizException
     */
    List<MasterDiscipleDto> findDiscipleList(Long masterId, Long operatingActivityId) throws BizException;

    /**
     * 分页查询徒弟列表
     * @param masterId 师傅id
     * @param pageNo
     * @param pageSize
     * @return 师徒关系列表
     * @throws BizException bizException
     */
    Page<MasterDiscipleDto> findDisciplePageApi(Long masterId, Long operatingActivityId, Integer pageNo, Integer pageSize) throws BizException;

    /**
     * 分页查询徒弟的徒弟列表
     * @param masterId 师傅id
     * @param pageNo
     * @param pageSize
     * @return 师徒关系列表
     * @throws BizException bizException
     */
    Page<MasterDiscipleDto> findDisciplePageOfDisciplesApi(Long masterId, Long operatingActivityId, Integer pageNo, Integer pageSize) throws BizException;

    /**
     * 查询师傅（只有一个师傅）
     * @param discipleId 徒弟id
     * @return 师徒关系
     * @throws BizException bizException
     */
    MasterDiscipleDto findMaster(Long discipleId, Long operatingActivityId) throws BizException;

    /**
     * 判断是否是师傅关系
     * @param masterId 师傅id
     * @param consumerId 徒弟id
     * @return 条数
     */
    Integer countByMasterIdAndConsumerId(Long masterId, Long consumerId, Long operatingActivityId) throws BizException;

    /**
     * 师徒奖励发奖并生成师徒关系
     * @param masterBonusParam 师徒参数
     * @return 是否成功
     * @throws BizException bizException
     */
    @Deprecated
    Boolean presentBonus(MasterBonusParam masterBonusParam) throws BizException;
}
