package cn.com.duiba.activity.custom.center.api.remoteservice.cmb;

import cn.com.duiba.activity.custom.center.api.dto.cmb.CmbTransferDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @program: activity-custom-center
 * @description: 招行转账记录
 * @author: Simba
 * @create: 2019-01-22 13:47
 **/
@AdvancedFeignClient
public interface RemoteCmbTransferService {

    Long insert(CmbTransferDto cmbTransferDto);

    /**
     * 根据业务号查询
     * @param yurref
     * @return
     */
    CmbTransferDto findByYurref(String yurref);

    /**
     * 修改为已重试
     * @param yurref
     * @return
     */
    int update2RetryByYurref(String yurref);

    /**
     * 修改状态为成功
     * @param yurref
     * @return
     */
    int update2SuccessByYurref(String yurref);

    /**
     * 修改状态为失败
     * @param yurref
     * @param failReason
     * @return
     */
    int update2FailByYurref(String yurref, String failReason);

    /**
     * 修改状态为卡单
     * @param yurref
     * @param stuckReason
     * @return
     */
    int update2StuckByYurref(String yurref, String stuckReason);
}

