package cn.com.duiba.activity.custom.center.api.enums.kuwo;

import com.google.common.collect.Maps;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.Map;

/**
 * Created by HePeng on 2019/03/15 14:48.
 */
public enum KuwoConsumerChanceSourceEnum {
    SOURCE_PLAY_SONG(1, "播放歌曲"),
    SOURCE_FAVOR_SONG(2, "收藏歌曲"),
    SOURCE_SHARE(3, "分享"),
    SOURCE_SEND_SONG(4, "投扭蛋"),
    SOURCE_SIGN(5, "签到"),
    SOURCE_NEW_VISIT(10, "新用户首次访问"),
    SOURCE_OLD_VISIT(11, "旧用户首次访问"),
    ;

    // 默认增加次数
    private static final int DEFAULT_ADD_TIMES = 1;
    // 新用户首次访问增加次数
    private static final int NEW_VISIT_ADD_TIMES = 2;
    // 访问过期天数
    private static final int VISIT_EXPIRE_ADD_DAYS = 1;
    // 不过期记录在当前时间基础上增加的年数
    private static final int NOT_EXPIRE_ADD_YEARS = 10;
    // 默认时区id
    private static final ZoneId DEFAULT_ZONE_ID = ZoneId.systemDefault();

    /******************* 实例字段 ************************/

    private Integer source;

    private String desc;

    private static Map<Integer, KuwoConsumerChanceSourceEnum> enumMap = Maps.newHashMap();
    static {
        enumMap.put(SOURCE_PLAY_SONG.getSource(), SOURCE_PLAY_SONG);
        enumMap.put(SOURCE_FAVOR_SONG.getSource(), SOURCE_FAVOR_SONG);
        enumMap.put(SOURCE_SHARE.getSource(), SOURCE_SHARE);
        enumMap.put(SOURCE_SIGN.getSource(), SOURCE_SIGN);
    }

    KuwoConsumerChanceSourceEnum(Integer source, String desc) {
        this.source = source;
        this.desc = desc;
    }

    public static KuwoConsumerChanceSourceEnum getBySource(Integer source) {
        return enumMap.get(source);
    }

    public int getTaskBit() {
        if(isVisitSource()) {
            return 1;
        }
        return 1 << source;
    }

    public int getAddTimes() {
        if(this == SOURCE_NEW_VISIT) {
            return NEW_VISIT_ADD_TIMES;
        }
        return DEFAULT_ADD_TIMES;
    }

    public Date getExpireTime() {
        if(isVisitSource()) {
            return Date.from(LocalDate.now().plusDays(VISIT_EXPIRE_ADD_DAYS).atStartOfDay(DEFAULT_ZONE_ID).toInstant());
        }
        return Date.from(LocalDate.now().plusYears(NOT_EXPIRE_ADD_YEARS).atStartOfDay(DEFAULT_ZONE_ID).toInstant());
    }

    /**
     * 是否是访问来源
     * @return
     */
    private boolean isVisitSource() {
        return this == SOURCE_NEW_VISIT || this == SOURCE_OLD_VISIT;
    }

    public Integer getSource() {
        return source;
    }

    public String getDesc() {
        return desc;
    }
}
