package cn.com.duiba.activity.custom.center.api.remoteservice.kuwo;

import cn.com.duiba.activity.custom.center.api.dto.kuwo.KuwoConsumerSongDto;
import cn.com.duiba.activity.custom.center.api.dto.kuwo.KuwoDrawOnePoolSongResultDto;
import cn.com.duiba.activity.custom.center.api.dto.kuwo.KuwoPoolSongDto;
import cn.com.duiba.activity.custom.center.api.enums.kuwo.KuwoConsumerChanceSourceEnum;
import cn.com.duiba.activity.custom.center.api.params.kuwo.KuwoConsumerSongListParam;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 酷我音乐扭蛋活动服务
 * Created by HePeng on 2019/03/15 18:12.
 */
@AdvancedFeignClient
public interface RemoteKuwoSongService {
    /**
     * 给用户加指定来源的机会记录
     * @param consumerId
     * @param sourceEnum
     * @throws BizException
     * @return 实际来源，null表示之前已经完成过
     */
    KuwoConsumerChanceSourceEnum addChance(Long consumerId, KuwoConsumerChanceSourceEnum sourceEnum) throws BizException;

    /**
     * 查询用户有效剩余次数
     * @param consumerId
     * @return
     */
    Integer getValidChanceLeftTimes(Long consumerId);

    /**
     * 查询用户没有使用的扭蛋个数
     * @param consumerId
     * @return
     */
    Integer getNotUseSongCnt(Long consumerId);

    /**
     * 批量往扭蛋池中加扭蛋
     * @param poolSongDtoList
     */
    void batchAddPoolSong(List<KuwoPoolSongDto> poolSongDtoList);

    /**
     * 用户往扭蛋机中加扭蛋
     * @param consumerId
     * @param songJson
     * @param sendConsumerNick
     */
    void addPoolSong(Long consumerId, String songJson, String sendConsumerNick) throws BizException;

    /**
     * 用户使用掉一次机会
     * @param consumerId
     * @throws BizException
     */
    void useOneTime(Long consumerId) throws BizException;

    /**
     * 抽中扭蛋后处理
     * @param consumerId
     * @return
     * @throws BizException
     */
    KuwoDrawOnePoolSongResultDto drawOnePoolSongForPrize(Long consumerId) throws BizException;

    /**
     * 用户扭蛋分页列表
     * @param param
     * @return
     */
    List<KuwoConsumerSongDto> consumerSongList(KuwoConsumerSongListParam param);
}
