package cn.com.duiba.activity.custom.center.api.enums.atour;

import java.util.HashMap;
import java.util.Map;

/**
 * @auther: linjianhui
 * @date: 2019-01-11 11:43
 * @description: 对战记录类型
 */
public enum AtourBattleTypeEnum {

    /**
     * 随机对战
     */
    RANDOM(1, "随机对战"),

    /**
     * 未被挑战
     */
    UNDONE(2, "未被挑战"),

    /**
     * 已被挑战
     */
    DONE(3, "已被挑战"),

    /**
     * 接受挑战
     */
    ACCEPT(4, "接受挑战");

    private static Map<Integer, AtourBattleTypeEnum> typeEnumMap = new HashMap<>();

    static {
        for (AtourBattleTypeEnum typeEnum : AtourBattleTypeEnum.values()) {
            typeEnumMap.put(typeEnum.getCode(), typeEnum);
        }
    }

    private Integer code;
    private String desc;

    AtourBattleTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 通过code获取记录类型
     * @param code
     * @return
     */
    public static AtourBattleTypeEnum getByCode(int code) {
        return typeEnumMap.get(code);
    }
}
