package cn.com.duiba.activity.custom.center.api.remoteservice;

import cn.com.duiba.activity.custom.center.api.dto.watsons.CouponDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2018/8/5 16:06
 */
@AdvancedFeignClient
public interface RemoteWatsonsPrizeService {

    /**
     * 查询优惠券信息
     * @param couponCode 券码
     * @param consumerId 用户ID
     * @return 优惠券信息
     */
    CouponDto getCouponStatus(String couponCode, Long consumerId);

    /**
     * 查询中奖结果
     * @param activityOrder
     * @return
     */
    CouponDto findByActivityOrder(String activityOrder);

    /**
     * 随机获取20条记录
     * @return 中奖信息
     */
    List<CouponDto> getRandomPrizeList();

    /**
     * 查询用户中奖记录
     * @param consumerId 用户ID
     * @return 中奖记录
     */
    List<CouponDto> findPrizeRecord(Long consumerId);

}
