package cn.com.duiba.activity.custom.center.api.remoteservice.annaier;

import cn.com.duiba.activity.custom.center.api.dto.annaier.AnrGroupDetailDto;
import cn.com.duiba.activity.custom.center.api.dto.annaier.AnrGroupRecordDto;
import cn.com.duiba.activity.custom.center.api.params.annaier.JoinGroupParam;
import cn.com.duiba.activity.custom.center.api.params.annaier.OpenGroupParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

/**
 * @Author: lufeng
 * @Description: 安奈儿定制0元拼团接口
 * 技术文档：http://cf.dui88.com/pages/viewpage.action?pageId=22306587
 * 需求文档：http://cf.dui88.com/pages/viewpage.action?pageId=22302444
 * @Date: Created in 2019/6/10
 */
@AdvancedFeignClient
public interface RemoteAnrGroupService {

    /**
     * 开团
     * @param param
     * @return
     */
    Long openGroup(OpenGroupParam param);

    /**
     * 参团
     * @param param
     * @return
     */
    Boolean joinGroup(JoinGroupParam param);

    /**
     * 开奖处理
     * @param groupRecordId
     * @param ifGetPrize 是否可中奖
     * @return
     */
    Boolean openPrize(Long groupRecordId, boolean ifGetPrize);

    /**
     * 获取拼团信息
     * @param groupRecordId
     * @return
     */
    AnrGroupRecordDto getAnrGroup(Long groupRecordId);

    /**
     * 获取拼团详情(含拼团人信息)
     * @param groupRecordId
     * @return
     */
    AnrGroupDetailDto getAnrGroupDetail(Long groupRecordId);

    /**
     * 更新分享码
     * @param id
     * @param shareCode
     * @return
     */
    Boolean updateGroupShareCode(Long id, String shareCode);

    /**
     * 修改团状态
     * @param groupRecordId
     * @param groupStatus
     * @return
     */
    Boolean updateGroupRecordStatus(Long groupRecordId, Integer groupStatus);

    /**
     * 查询过期的拼团记录
     * @param appId
     * @return
     */
    List<AnrGroupRecordDto> selectExpireGroupRecord(Long appId);


    /**
     * 更新拼团记录为过期
     * @param groupRecordIds
     * @return
     */
    Integer updateAnrGroupStatusToFail(List<Long> groupRecordIds);


    /**
     * 批量查询团记录
     * @param groupRecordIds
     * @return
     */
    List<AnrGroupRecordDto> listGroupRecord(List<Long> groupRecordIds);


}
