package cn.com.duiba.activity.custom.center.api.remoteservice.sjf;

import cn.com.duiba.activity.custom.center.api.dto.sjf.SjfJoinRecordDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 水井坊-用户活动参与记录
 */
@AdvancedFeignClient
public interface RemoteSjfJoinRecordService {

	/**
	 * 新增
	 */
	Long add(SjfJoinRecordDto dto);

	/**
	 * 根据主键id查询
	 */
	SjfJoinRecordDto selectById(Long id);

	/**
	 * 根据活动id和用户uid查询用户活动参与次数
	 */
	Integer findCountByActivityIdAndUid(Long activityId, String uid);

	/**
	 * 根据活动id list批量查询活动下所有用户中奖记录
	 */
	List<SjfJoinRecordDto> findWinListByActivityIds(List<Long> activityIds);

	/**
	 * 根据用户uid查询用户中奖记录
	 */
	List<SjfJoinRecordDto> findWinListByUid(Long uid);
}
