package cn.com.duiba.activity.custom.center.api.remoteservice.bonus;

import cn.com.duiba.activity.custom.center.api.dto.bonus.DeveloperBonusLogDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 该 service 适用与于开发者对接红包或者其他奖励，具体奖励由开发者发放，我方只负责调用对方接口进行通知
 *
 * @author chengsiyi
 * @date 2018/12/3 10:38
 */
@AdvancedFeignClient
public interface RemoteDeveloperBonusLogService {

    /**
     * 插入日志记录，consumerId，appId，partnerUserId，缺一不可，bonus默认0
     *
     * @param developerBonusLogDto 数据
     * @return boolean
     */
    Long insertLog(DeveloperBonusLogDto developerBonusLogDto);


    /**
     * 根据用户ID获取红包记录，缓存时间1小时
     *
     * @param consumerId 用户ID
     * @return 红包记录
     */
    List<DeveloperBonusLogDto> getRecordByCid(Long consumerId);

}
