package cn.com.duiba.activity.custom.center.api.remoteservice.atour;

import cn.com.duiba.activity.custom.center.api.dto.atour.ActivityOldUserInfoDto;
import cn.com.duiba.activity.custom.center.api.paramquery.PageQueryParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

/**
 * @author linjianhui
 * @description 亚朵答题对战用户信息
 * @date 2019-01-09 10:42
 */
@AdvancedFeignClient
public interface RemoteAtourBattleUserService {

    /**
     * 获取之前参与过活动，指定时间点之后没参与的用户（分页）
     * @param pageNo  当前页码
     * @param pageSize 每页条数
     * @param timePoint  指定时间点
     * @return
     */
    List<ActivityOldUserInfoDto> getOldUserList(Integer pageNo, Integer pageSize, Date timePoint);

    /**
     * 插入或更新用户信息
     * @param dto
     * @return
     */
    Integer insertOrUpdate(ActivityOldUserInfoDto dto);
}
