package cn.com.duiba.activity.custom.center.api.remoteservice.cscmbc;

import cn.com.duiba.activity.custom.center.api.dto.cscmbc.CscmbcProgramDetailDto;
import cn.com.duiba.activity.custom.center.api.dto.cscmbc.CscmbcUnlockInfoDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author: zhengjianhao
 * @date: 2019/7/8 11:35
 * @description: 长沙招行打call活动
 */
@AdvancedFeignClient
public interface RemoteCscmbcCallService {

    /**
     * 获取今日解锁的节目
     */
    CscmbcUnlockInfoDto getUnlockedActivity(Long consumerId) throws BizException;

    /**
     * 首页自己打call
     */
    String selfCall(Long consumerId, Integer programType) throws BizException;

    /**
     * 节目详情
     */
    CscmbcProgramDetailDto programDetail(Long consumerId, Integer programType) throws BizException;

    /**
     * 分享打call
     */
    void shareCall(Long consumerId, Integer programType) throws BizException;

    /**
     * 好友助力打call
     */
    void helpCall(Long invitedConsumerId, String shareCode) throws BizException;

    /**
     * 获取用户个人贡献总call值信息
     */
    List<CscmbcProgramDetailDto> programInfoList(Long consumerId) throws BizException;
}
