package cn.com.duiba.activity.custom.center.api.dto.qqmusic;

import cn.com.duiba.activity.custom.center.api.enums.qqmusic.QQMusicAuctionPrizeStatusEnum;

import java.io.Serializable;

/**
 * @author: zhengjianhao
 * @date: 2019/7/22 16:58
 * @description: 商品拍卖活动-首页
 */
public class QQMusicAuctionIndexDto implements Serializable {

    private static final long serialVersionUID = -5986645640286195289L;

    /**
     * 当前场次日期
     */
    private Long recordDate;

    /**
     * 当前场次奖品id
     */
    private Long prizeId;

    /**
     * 当前场次奖品名称
     */
    private String prizeName;

    /**
     * 当前场次奖品图片
     */
    private String prizeImage;

    /**
     * 当前场次状态：0，未开始；1，进行中；2，已结束
     *
     * @see cn.com.duiba.activity.custom.center.api.enums.qqmusic.QQMusicAuctionPrizeStatusEnum
     */
    private Integer auctionStatus = QQMusicAuctionPrizeStatusEnum.NOT_STARTED.getCode();

    /**
     * 当前场次开始时间
     */
    private Long startTime;

    /**
     * 当前场次结束时间
     */
    private Long endTime;

    /**
     * 是否有上一场
     */
    private Boolean hasLastAuction = false;

    /**
     * 上一场次日期
     */
    private Long lastAuctionDate;

    /**
     * 是否有下一场
     */
    private Boolean hasNextAuction = false;

    /**
     * 下一场次日期
     */
    private Long nextAuctionDate;

    /**
     * 限量
     */
    private Integer limitCount;

    /**
     * 我的出价
     */
    private Long myBid;

    /**
     * 上一场成交价
     */
    private Long lastAuctionBid;

    /**
     * 是否可领奖
     */
    private Boolean hasWin = false;

    /**
     * 中奖场次日期时间戳
     */
    private Long winDate;

    /**
     * 中奖场次出价
     */
    private Long winBid;

    /**
     * 中奖场次奖品名称
     */
    private String winPrizeName;

    /**
     * 中奖场次奖品图片
     */
    private String winPrizeImage;

    /**
     * 中奖出价记录id
     */
    private Long winRecordId;

    public Long getRecordDate() {
        return recordDate;
    }

    public void setRecordDate(Long recordDate) {
        this.recordDate = recordDate;
    }

    public Long getPrizeId() {
        return prizeId;
    }

    public void setPrizeId(Long prizeId) {
        this.prizeId = prizeId;
    }

    public String getPrizeName() {
        return prizeName;
    }

    public void setPrizeName(String prizeName) {
        this.prizeName = prizeName;
    }

    public String getPrizeImage() {
        return prizeImage;
    }

    public void setPrizeImage(String prizeImage) {
        this.prizeImage = prizeImage;
    }

    public Integer getAuctionStatus() {
        return auctionStatus;
    }

    public void setAuctionStatus(Integer auctionStatus) {
        this.auctionStatus = auctionStatus;
    }

    public Long getStartTime() {
        return startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public Boolean getHasLastAuction() {
        return hasLastAuction;
    }

    public void setHasLastAuction(Boolean hasLastAuction) {
        this.hasLastAuction = hasLastAuction;
    }

    public Long getLastAuctionDate() {
        return lastAuctionDate;
    }

    public void setLastAuctionDate(Long lastAuctionDate) {
        this.lastAuctionDate = lastAuctionDate;
    }

    public Boolean getHasNextAuction() {
        return hasNextAuction;
    }

    public void setHasNextAuction(Boolean hasNextAuction) {
        this.hasNextAuction = hasNextAuction;
    }

    public Long getNextAuctionDate() {
        return nextAuctionDate;
    }

    public void setNextAuctionDate(Long nextAuctionDate) {
        this.nextAuctionDate = nextAuctionDate;
    }

    public Integer getLimitCount() {
        return limitCount;
    }

    public void setLimitCount(Integer limitCount) {
        this.limitCount = limitCount;
    }

    public Long getMyBid() {
        return myBid;
    }

    public void setMyBid(Long myBid) {
        this.myBid = myBid;
    }

    public Long getLastAuctionBid() {
        return lastAuctionBid;
    }

    public void setLastAuctionBid(Long lastAuctionBid) {
        this.lastAuctionBid = lastAuctionBid;
    }

    public Boolean getHasWin() {
        return hasWin;
    }

    public void setHasWin(Boolean hasWin) {
        this.hasWin = hasWin;
    }

    public Long getWinDate() {
        return winDate;
    }

    public void setWinDate(Long winDate) {
        this.winDate = winDate;
    }

    public Long getWinBid() {
        return winBid;
    }

    public void setWinBid(Long winBid) {
        this.winBid = winBid;
    }

    public String getWinPrizeName() {
        return winPrizeName;
    }

    public void setWinPrizeName(String winPrizeName) {
        this.winPrizeName = winPrizeName;
    }

    public String getWinPrizeImage() {
        return winPrizeImage;
    }

    public void setWinPrizeImage(String winPrizeImage) {
        this.winPrizeImage = winPrizeImage;
    }

    public Long getWinRecordId() {
        return winRecordId;
    }

    public void setWinRecordId(Long winRecordId) {
        this.winRecordId = winRecordId;
    }
}
