package cn.com.duiba.activity.custom.center.api.remoteservice.suzhoubank;

import cn.com.duiba.activity.custom.center.api.dto.suzhoubank.SuZhouBankTaskDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author: zhengjianhao
 * @date: 2019/6/3 10:46
 * @description: 苏州银行任务中心
 */
@AdvancedFeignClient
public interface RemoteSuZhouBankTaskService {

    /**
     * 新增记录
     */
    int add(SuZhouBankTaskDto suZhouBankTaskDto);

    /**
     * 更新任务状态json
     */
    int modifyTasks(Long id, String tasks);

    /**
     * 根据用户id、月份id、年id查询单月记录
     */
    SuZhouBankTaskDto findOne(Long consumerId, Integer monthId, Integer yearId);

    /**
     * 根据用户id、月份id list、年id批量查询
     */
    List<SuZhouBankTaskDto> findList(Long consumerId, List<Integer> monthIds, Integer yearId);
}
