package cn.com.duiba.activity.custom.center.api.dto.happyclear;

import cn.com.duiba.activity.custom.center.api.params.happyclear.HappyClearAwardQueryParam;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 消消乐-用户发奖请求提交记录
 */
public class HappyClearAwardRecordDto implements Serializable {

    /**
     * 提交成功
     */
    public static final int SUBMIT_SUCCESS = 1;

    /**
     * 提交失败
     */
    public static final int SUBMIT_FAIL = 0;

    /**
     * 自增id
     */
    private Long id;

    /**
     * APPID
     */
    @NotNull
    private Long appId;

    /**
     * 用户id
     */
    @NotNull
    private Long consumerId;

    /**
     * 子订单号
     */
    private String orderNum;

    /**
     * 主订单号
     */
    private String mainOrderNum;

    /**
     * 入库活动id
     */
    private Long operatingActivityId;

    /**
     * 兑吧活动id
     */
    private Long duibaActivityId;

    /**
     * 活动类型
     *
     * @see cn.com.duiba.api.enums.ActivityUniformityTypeEnum#code
     */
    @NotNull
    private Integer activityType;

    /**
     * 开发者商品id
     */
    private Long appItemId;

    /**
     * 兑吧商品id
     */
    private Long itemId;

    /**
     * 业务类型
     *
     * @see cn.com.duiba.activity.custom.center.api.enums.happyclear.HappyClearAwardBizTypeEnum#code
     */
    @NotNull
    private Integer bizType;

    /**
     * 奖品类型
     *
     * @see cn.com.duiba.activity.common.center.api.enums.happyclear.HappyClearTypeEnum#code
     */
    @NotNull
    private Integer optionType;

    /**
     * 变更数量（针对奖品为元宝和体力时）
     */
    private Long changeNum;

    /**
     * 提交状态 0:成功 1:失败
     *
     * @see HappyClearAwardQueryParam#SUBMIT_SUCCESS
     * @see HappyClearAwardQueryParam#SUBMIT_FAIL
     */
    @NotNull
    private Integer submitStatus;

    /**
     * 描述信息
     */
    private String submitDesc;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setMainOrderNum(String mainOrderNum) {
        this.mainOrderNum = mainOrderNum;
    }

    public String getMainOrderNum() {
        return mainOrderNum;
    }

    public void setOperatingActivityId(Long operatingActivityId) {
        this.operatingActivityId = operatingActivityId;
    }

    public Long getOperatingActivityId() {
        return operatingActivityId;
    }

    public void setDuibaActivityId(Long duibaActivityId) {
        this.duibaActivityId = duibaActivityId;
    }

    public Long getDuibaActivityId() {
        return duibaActivityId;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public Integer getBizType() {
        return bizType;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public Integer getSubmitStatus() {
        return submitStatus;
    }

    public void setSubmitStatus(Integer submitStatus) {
        this.submitStatus = submitStatus;
    }

    public String getSubmitDesc() {
        return submitDesc;
    }

    public void setSubmitDesc(String submitDesc) {
        this.submitDesc = submitDesc;
    }

    public Integer getOptionType() {
        return optionType;
    }

    public void setOptionType(Integer optionType) {
        this.optionType = optionType;
    }

    public Long getChangeNum() {
        return changeNum;
    }

    public void setChangeNum(Long changeNum) {
        this.changeNum = changeNum;
    }
}

