package cn.com.duiba.activity.custom.center.api.enums.sjf;

import java.util.Objects;

/**
 * @author: zhengjianhao
 * @date: 2019/6/24 11:11
 * @description: 水井坊活动类型
 */
public enum ActivityTypeEnum {


    BIG_WHEEL(1,"幸福大转盘"),
    CLIP_DOLL_MACHINE(2,"惊喜娃娃机"),
    GIFT_TREE(3,"神奇礼物树"),
    SHAKE_FIGHTER(4, "喜糖摇摇乐"),
    ;

    private Integer code;

    private  String title;

    ActivityTypeEnum(Integer code, String title) {
        this.code = code;
        this.title = title;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public static String getTitleByCode(Integer code){
        if(null == code){
            return null;
        }
        for(ActivityTypeEnum activityTypeEnum: ActivityTypeEnum.values()){
            if(Objects.equals(activityTypeEnum.getCode(), code)){
                return activityTypeEnum.getTitle();
            }
        }
        return null;
    }
}
