package cn.com.duiba.activity.custom.center.api.remoteservice;

import cn.com.duiba.activity.custom.center.api.dto.CountDownPoolDto;
import cn.com.duiba.activity.custom.center.api.paramquery.CountDownPoolQueryParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2019/4/29 17:21
 */
@AdvancedFeignClient
public interface RemoteCountDownPoolService {

    /**
     * 保存数据
     * @param dto
     * @return
     */
    Integer insert(CountDownPoolDto dto);

    /**
     * 获取数据列表
     * @param queryParam
     * @return
     */
    List<CountDownPoolDto> getDataList(CountDownPoolQueryParam queryParam);

    /**
     *
     * 批量删除
     * @param ids {@link #getDataList(CountDownPoolQueryParam)} 获取的数据
     * @return
     */
    Integer batchDelete(List<Long> ids);

}
