package cn.com.duiba.activity.custom.center.api.remoteservice.ccb;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 建行相关兑换限制
 * Created by 歪大哥😁 on 2019-10-16.
 */
@AdvancedFeignClient
public interface RemoteCcbExchangeLimitService {

    // 当前手机号今日是否还可以兑换 上线为10次
    boolean canExchangeToday(String phone);
    // 回滚当前手机号今日的兑换次数
    boolean rollBackExchangeCountToday(String phone);

    /** 通过hbase实现的通用计数器 变更后数值 返回null表示变更失败 */
    Long hBaseCounterIncr(String itemCode, Long delta);

    /** 查询通过hbase实现的通用计数器当前数值  若不存在则返回0 */
    Long getCountValue(String itemCode);

}
