package cn.com.duiba.activity.custom.center.api.enums.coupon;

import java.util.HashMap;
import java.util.Map;

/**
 * @author chengsiyi
 * @date 2019/6/24 10:49
 */
public enum CouponVerificationEnum {

    /**
     * 0-未使用，1-已使用，2-已失效
     */
    UNUSED(0, "未使用"),
    USED(1,"已使用"),
    INVALID(2,"已失效"),
    ;

    private Integer couponStatus;

    private String desc;

    private static final Map<Integer, CouponVerificationEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CouponVerificationEnum tmp : values()){
            ENUM_MAP.put(tmp.getCouponStatus(), tmp);
        }
    }

    CouponVerificationEnum(Integer couponStatus, String desc) {
        this.couponStatus = couponStatus;
        this.desc = desc;
    }

    public Integer getCouponStatus() {
        return couponStatus;
    }

    public String getDesc() {
        return desc;
    }

    public static CouponVerificationEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
