package cn.com.duiba.activity.custom.center.api.enums.watsons;

import java.util.HashMap;
import java.util.Map;

/**
 * @author chengsiyi
 * @date 2019/8/15 16:42
 */
public enum WatsonsVipEnum {
    /**
     * 会员等级
     */
    BASE(4, "Base", "潮流小主"),
    ELITE(8, "Elite", "闪亮达人"),
    ELITE_PLUS(7, "Elite Plus", "时尚教主");

    /**
     * 会员等级
     */
    Integer vipLevel;

    /**
     * 英文名称
     */
    String english;

    /**
     * 中文描述
     */
    String desc;

    WatsonsVipEnum(Integer vipLevel, String english, String desc) {
        this.vipLevel = vipLevel;
        this.english = english;
        this.desc = desc;
    }

    public Integer getVipLevel() {
        return vipLevel;
    }

    public String getEnglish() {
        return english;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, WatsonsVipEnum> ENUM_MAP = new HashMap<>();

    static {
        for (WatsonsVipEnum tmp : values()) {
            ENUM_MAP.put(tmp.getVipLevel(), tmp);
        }
    }

    public static WatsonsVipEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
