package cn.com.duiba.activity.custom.center.api.dto.hsbc;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Author: fss
 * @Date: 2022/10/9 16
 * @Description:
 */
public class HsbcWithdrawDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 发奖规则
     */
    private String rule;

    /**
     * 档位标识
     */
    private List<GearConfig> gearConfigList;

    /**
     * 总提现限制次数(根据总提现限制次数类型)
     */
    private Integer totalLimitCount;

    /**
     * 总提现限制次数类型:1:每日;2:永久
     */
    private Integer totalLimitCountType;

    /**
     * 单用户提现预算(每日总)
     */
    private Long consumerLimitAmount;

    /**
     * 提现预算(每日总)
     */
    private Long limitAmount;

    /**
     * 预算预警值(每日总)
     */
    private Long warnAmount;

    /**
     * 预警手机号
     */
    private String warnPhone;

    public String getRule() {
        return rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public List<GearConfig> getGearConfigList() {
        return gearConfigList;
    }

    public void setGearConfigList(List<GearConfig> gearConfigList) {
        this.gearConfigList = gearConfigList;
    }

    public Integer getTotalLimitCount() {
        return totalLimitCount;
    }

    public void setTotalLimitCount(Integer totalLimitCount) {
        this.totalLimitCount = totalLimitCount;
    }

    public Integer getTotalLimitCountType() {
        return totalLimitCountType;
    }

    public void setTotalLimitCountType(Integer totalLimitCountType) {
        this.totalLimitCountType = totalLimitCountType;
    }

    public Long getConsumerLimitAmount() {
        return consumerLimitAmount;
    }

    public void setConsumerLimitAmount(Long consumerLimitAmount) {
        this.consumerLimitAmount = consumerLimitAmount;
    }

    public Long getLimitAmount() {
        return limitAmount;
    }

    public void setLimitAmount(Long limitAmount) {
        this.limitAmount = limitAmount;
    }

    public Long getWarnAmount() {
        return warnAmount;
    }

    public void setWarnAmount(Long warnAmount) {
        this.warnAmount = warnAmount;
    }

    public String getWarnPhone() {
        return warnPhone;
    }

    public void setWarnPhone(String warnPhone) {
        this.warnPhone = warnPhone;
    }

    public static class GearConfig implements Serializable {
        private static final long serialVersionUID = 1L;

        /**
         * 档位唯一标识
         */
        private String gearUniqueKey;

        /**
         * 排序,数值越小优先级越高，最小的代表一档
         */
        private Integer sort;

        /**
         * 金额:分
         */
        @NotNull(message = "金额不可为空")
        private Long amount;

        /**
         * 限制次数
         */
        private Long gearLimitCount;

        /**
         * 类型:1:每日;2:永久
         */
        @NotNull(message = "档位类型不可为空")
        private Integer type;

        /**
         * 限制变更的时间戳(所属标识的类型、金额变更时，后端主动变更时间)
         */
        private Long limitChangeTimeStamp;

        public Long getGearLimitCount() {
            return gearLimitCount;
        }

        public void setGearLimitCount(Long gearLimitCount) {
            this.gearLimitCount = gearLimitCount;
        }

        public String getGearUniqueKey() {
            return gearUniqueKey;
        }

        public void setGearUniqueKey(String gearUniqueKey) {
            this.gearUniqueKey = gearUniqueKey;
        }

        public Integer getSort() {
            return sort;
        }

        public void setSort(Integer sort) {
            this.sort = sort;
        }

        public Long getAmount() {
            return amount;
        }

        public void setAmount(Long amount) {
            this.amount = amount;
        }

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public Long getLimitChangeTimeStamp() {
            return limitChangeTimeStamp;
        }

        public void setLimitChangeTimeStamp(Long limitChangeTimeStamp) {
            this.limitChangeTimeStamp = limitChangeTimeStamp;
        }
    }
}

