package cn.com.duiba.activity.custom.center.api.remoteservice.identity;


import cn.com.duiba.activity.custom.center.api.dto.identity.IdentityCustomerRelationDto;
import cn.com.duiba.activity.custom.center.api.enums.identity.IdentityNewRelTypeEnum;
import cn.com.duiba.activity.custom.center.api.paramquery.identity.IdentityCustomerRelationConditionParam;
import cn.com.duiba.activity.custom.center.api.paramquery.identity.IdentityCustomerRelationParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteIdentityCustomerRelationSerivce {

    /**
     * rel_type，新增rel_type定义，须在新版枚举中，添加；老版定义知道的，也请补充到新版
     * @see cn.com.duiba.activity.custom.center.api.enums.identity.IdentityRelTypeEnum 旧版
     * @see cn.com.duiba.activity.custom.center.api.enums.identity.IdentityNewRelTypeEnum 新版
     * @param identityCustomerRelationDto
     * @return
     */

    Long save(IdentityCustomerRelationDto identityCustomerRelationDto);

    Integer deleteById(Long id);

    Integer deleteBatchByIds(List<Long> ids);

    Integer updateById(IdentityCustomerRelationDto identityCustomerRelationDto);

    IdentityCustomerRelationDto getById(Long id);

    List<IdentityCustomerRelationDto> listByIds(List<Long> ids);

    List<IdentityCustomerRelationDto> getByAppIdAndCondition(IdentityCustomerRelationParam identityCustomerRelationParam);

    IdentityCustomerRelationDto queryByRelContentAndPid(IdentityCustomerRelationDto dto);

    List<IdentityCustomerRelationDto> listByRelContents(List<String> uidBeats,Long appId,String relType);

    /**
     * 批量插入关联记录
     * @param identityCustomerRelationDtoList
     */
    void batchInsert(List<IdentityCustomerRelationDto> identityCustomerRelationDtoList);

    Integer updateIsDeleteById(Long id);

    Integer batchUpdateIsDeleteByIds(List<Long> ids);

    List<IdentityCustomerRelationDto> listByConditions(IdentityCustomerRelationConditionParam param);

    /**
     * 限制倒序查询记录
     * @param appId
     * @param cid
     * @param typeEnum
     * @param limit
     * @return
     */
    List<IdentityCustomerRelationDto> listCountRecordDesc(Long appId, Long cid, IdentityNewRelTypeEnum typeEnum, Integer limit);

    /**
     * 根据rel_content查询记录，如果有多条，返回最新的一条
     * @param dto
     * @return
     */
    IdentityCustomerRelationDto queryByRelContentWithPid(IdentityCustomerRelationDto dto);

    /**
     * 是否存在改订单记录
     * @param dto
     * @return
     */
    Boolean existInfoByRelContent(IdentityCustomerRelationDto dto);


    void deleteByAppIdAndRelContent(Long appId, String relType, String relContent);
}
