package cn.com.duiba.activity.custom.center.api.enums.questionnaire;

import java.util.Objects;

/**
 * @author haojiahong
 * @date 2020-05-27
 */
public enum QuestionnaireReleaseStatusEnum {
    INIT(0, "未投放"),
    RELEASING(1, "投放中"),
    RECOVERED( 2, "已完成"),
    ;
    private Integer status;
    private String statusName;

    QuestionnaireReleaseStatusEnum(Integer status, String statusName) {
        this.status = status;
        this.statusName = statusName;
    }

    public Integer getStatus() {
        return status;
    }

    public String getStatusName() {
        return statusName;
    }

    public static QuestionnaireReleaseStatusEnum getByStatus(Integer status) {
        for (QuestionnaireReleaseStatusEnum value : QuestionnaireReleaseStatusEnum.values()) {
            if (Objects.equals(value.getStatus(), status)) {
                return value;
            }
        }
        return null;
    }
}
