package cn.com.duiba.activity.custom.center.api.remoteservice.sjf;

import cn.com.duiba.activity.custom.center.api.dto.sjf.SjfJoinRecordDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 水井坊-用户活动参与记录（管理端用）
 */
@AdvancedFeignClient
public interface RemoteSjfJoinRecordBackendService {

	/**
	 * 根据活动id分页查询活动下所有用户中奖记录（管理端用）
	 */
	List<SjfJoinRecordDto> findWinListByActivityId(Long activityId, Integer pageNo, Integer pageSize, Long accountId) throws BizException;

	/**
	 * 领取：将中奖记录状态由待领取更新为已领取
	 */
	Boolean award(Long recordId, Long accountId) throws BizException;
}
