package cn.com.duiba.activity.custom.center.api.remoteservice.sjf;

import cn.com.duiba.activity.custom.center.api.dto.sjf.SjfOrderSimpleDto;
import cn.com.duiba.activity.custom.center.api.dto.sjf.SjfWeddingConfDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 水井坊-婚宴配置-管理端接口
 */
@AdvancedFeignClient
public interface RemoteSjfWeddingConfBackendService {

    /**
     * 新增配置
     */
    Long add(SjfWeddingConfDto dto) throws BizException;

    /**
     * 根据id查询配置详情-全部，包括婚宴配置、婚宴活动配置、婚宴活动奖品配置
     */
    SjfWeddingConfDto findWeddingConfAllInfo(Long id);

    /**
     * 根据创建的账户id分页查询
     */
    List<SjfWeddingConfDto> findWeddingConfList(Long accountId, Integer pageNo, Integer pageSize);

    /**
     * 根据创建的账户id和婚宴标题模糊匹配，分页查询婚宴活动信息
     */
    List<SjfOrderSimpleDto> findWeddingActivityList(Long accountId, String title, Integer pageNo, Integer pageSize);

    /**
     * 获取二维码
     */
    String createQrcode(Long weddingId, Long accountId) throws BizException;
}
