package cn.com.duiba.activity.custom.center.api.enums.ccb;

import java.util.HashMap;
import java.util.Map;

public enum WhiteListRecordStatusEnum {
    INIT(0, "初始化", true),
    SUCCESS(1, "录入成功", false),
    FAIL(2, "录入失败-建行已存在", false),
    TIME_OUT(3, "录入超时", true),
    NOT_EXIST(4, "建行不存在", true),
    ;
    private Integer code;

    private String desc;

    /**
     * 允许重试录入
     */
    private boolean allowRetry;


    WhiteListRecordStatusEnum(Integer code, String desc, boolean allowRetry) {
        this.code = code;
        this.desc = desc;
        this.allowRetry = allowRetry;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public boolean isAllowRetry() {
        return allowRetry;
    }


    private static final Map<Integer, WhiteListRecordStatusEnum> ENUM_MAP = new HashMap<>();

    static{
        for(WhiteListRecordStatusEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static WhiteListRecordStatusEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }

}
