package cn.com.duiba.activity.custom.center.api.enums.tasklog;

import org.apache.commons.lang.StringUtils;

/**
 * @author haojiahong
 * @date 2021-03-31
 */
public enum TaskKindEnum {
    DAY_SIGN("每日签到", 1),
    DAY_TOPIC_PK("参与话题pk", 1),

    CREDITS_LOTTERY("积分抽奖", 1),
    INVITE("推荐好友", 1),
    CREDITS_RANK("积分排行榜", 1),

    ARTICLE("阅读文章", 1),


    ;


    private String desc;
    /**
     * 1：每日任务，2：永久任务
     */
    private Integer taskType;

    TaskKindEnum(String desc, Integer taskType) {
        this.desc = desc;
        this.taskType = taskType;
    }

    public static Boolean contains(String name) {
        for (TaskKindEnum value : TaskKindEnum.values()) {
            if (StringUtils.equals(name, value.name())) {
                return true;
            }
        }
        return false;
    }

    public static TaskKindEnum getByName(String taskKind) {
        for (TaskKindEnum value : TaskKindEnum.values()) {
            if (StringUtils.equals(taskKind, value.name())) {
                return value;
            }
        }
        return null;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getTaskType() {
        return taskType;
    }
}
