package cn.com.duiba.activity.custom.center.api.remoteservice.blacklist;

import cn.com.duiba.activity.custom.center.api.dto.blacklist.UserBlackListDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author haojiahong
 * @date 2021-01-12
 */
@AdvancedFeignClient
public interface RemoteUserBlackListService {

    /**
     * 批量插入黑名单
     *
     * @param appId
     * @param relType
     * @param relValueList
     * @return
     */
    Void batchInsert(Long appId, Integer relType, List<String> relValueList);

    /**
     * 批量删除黑名单
     *
     * @param appId
     * @param relType
     * @param relValueList
     * @return
     */
    Void batchDelete(Long appId, Integer relType, List<String> relValueList);


    /**
     * 通过条件查询用户黑名单
     *
     * @param appId
     * @param relType
     * @param relValue
     * @return
     */
    UserBlackListDto getByArr(Long appId, Integer relType, String relValue);

}
