package cn.com.duiba.activity.custom.center.api.dto.happyclear;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhengjianhao
 * @date 2019/10/27
 * @description 苏宁消消乐-刮刮卡任务
 */
public class HappyClearScratchCardTaskDto implements Serializable {

	private static final long serialVersionUID = 5626677130092925931L;
	/**
	 * 主键id
	 */
	private Long id;

	/**
	 * appid
	 */
	private Long appId;

	/**
	 * 入库活动id
	 */
	private Long activityId;

	/**
	 * 用户id
	 */
	private Long consumerId;

	/**
	 * 刮刮卡配置id
	 */
	private String scratchCardId;

	/**
	 * 刮刮卡档位
	 */
	private Integer cardLevel;

	/**
	 * 奖品类型：1、无奖励；2、游戏次数；3、游戏道具；4、游戏元宝；5、实物；6、优惠券；7、虚拟商品
	 * @see cn.com.duiba.activity.common.center.api.enums.happyclear.HappyClearTypeEnum
	 */
	private Integer prizeType;

	/**
	 * 奖品id
	 */
	private Long appItemId;

	/**
	 * 奖项名称
	 */
	private String prizeName;

	/**
	 * 奖品图片
	 */
	private String prizeImage;

	/**
	 * 虚拟商品标识符
	 */
	private String virtualIdentifier;

	/**
	 * 结束时间
	 */
	private Date endTime;

	/**
	 * 初始随机进度
	 */
	private Integer initRate;

	/**
	 * 总共需要助力人数
	 */
	private Integer needNum;

	/**
	 * 状态：1、进行中；2、已完成待领奖；3、已完成领奖成功；4、已完成领奖失败；5、任务失败
	 * @see cn.com.duiba.activity.custom.center.api.enums.happyclear.ScratchCardTaskStatusEnum
	 */
	private Integer taskStatus;

	/**
	 * 子订单号
	 */
	private String orderNum;

	/**
	 * 主订单号
	 */
	private String mainOrderNum;

	/**
	 * 错误信息
	 */
	private String errorMessage;

	/**
	 * 创建时间
	 */
	private Date gmtCreate;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getActivityId() {
		return activityId;
	}

	public void setActivityId(Long activityId) {
		this.activityId = activityId;
	}

	public Long getConsumerId() {
		return consumerId;
	}

	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}

	public String getScratchCardId() {
		return scratchCardId;
	}

	public void setScratchCardId(String scratchCardId) {
		this.scratchCardId = scratchCardId;
	}

	public Integer getCardLevel() {
		return cardLevel;
	}

	public void setCardLevel(Integer cardLevel) {
		this.cardLevel = cardLevel;
	}

	public Integer getPrizeType() {
		return prizeType;
	}

	public void setPrizeType(Integer prizeType) {
		this.prizeType = prizeType;
	}

	public Long getAppItemId() {
		return appItemId;
	}

	public void setAppItemId(Long appItemId) {
		this.appItemId = appItemId;
	}

	public String getPrizeName() {
		return prizeName;
	}

	public void setPrizeName(String prizeName) {
		this.prizeName = prizeName;
	}

	public String getPrizeImage() {
		return prizeImage;
	}

	public void setPrizeImage(String prizeImage) {
		this.prizeImage = prizeImage;
	}

	public String getVirtualIdentifier() {
		return virtualIdentifier;
	}

	public void setVirtualIdentifier(String virtualIdentifier) {
		this.virtualIdentifier = virtualIdentifier;
	}

	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public Integer getInitRate() {
		return initRate;
	}

	public void setInitRate(Integer initRate) {
		this.initRate = initRate;
	}

	public Integer getNeedNum() {
		return needNum;
	}

	public void setNeedNum(Integer needNum) {
		this.needNum = needNum;
	}

	public Integer getTaskStatus() {
		return taskStatus;
	}

	public void setTaskStatus(Integer taskStatus) {
		this.taskStatus = taskStatus;
	}

	public String getOrderNum() {
		return orderNum;
	}

	public void setOrderNum(String orderNum) {
		this.orderNum = orderNum;
	}

	public String getMainOrderNum() {
		return mainOrderNum;
	}

	public void setMainOrderNum(String mainOrderNum) {
		this.mainOrderNum = mainOrderNum;
	}

	public String getErrorMessage() {
		return errorMessage;
	}

	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}
}
