package cn.com.duiba.activity.custom.center.api.enums.abcgoods;

import org.apache.commons.lang.StringUtils;

/**
 * @author haojiahong
 * @date 2021-06-29
 */
public enum CmdyStsEnum {

    UP_WAIT("00", "上架待审核"),
    UP_ED("01", "在售"),
    DOWN_WAIT("02", "下架待审核"),
    DOWN_ED("03", "已下架或无效");


    private String status;
    private String desc;

    CmdyStsEnum(String status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public String getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    public static CmdyStsEnum getByStatus(String status) {
        for (CmdyStsEnum value : CmdyStsEnum.values()) {
            if (StringUtils.equals(value.getStatus(), status)) {
                return value;
            }
        }
        return null;
    }
}
