package cn.com.duiba.activity.custom.center.api.enums.citic;

import cn.com.duiba.activity.custom.center.api.enums.ccb.SupplierOrderStatusEnum;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: fss
 * @Date: 2022/8/29 11
 * @Description:
 */
public enum TypeEnum {
    BLACK(1, "黑名单类型"),
    TASK_ONE(2,"奖励任务1"),
    TASK_TWO(3,"奖励任务2"),
    ;

    private Integer type;

    private String desc;

    private static final Map<Integer, TypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(TypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }

    TypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static TypeEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
