package cn.com.duiba.activity.custom.center.api.enums.kww;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @Author: fss
 * @Date: 2022/9/13 14
 * @Description:
 */
public enum KwwCreditsStatusEnum {
    /**
     * 状态:1:初始;2:成功,3:失败(扣积分订单号重复),4:超时
     */
    INIT(1, "初始"),
    SUCCESS(2, "成功"),
    FAIL(3, "失败"),
    TIMEOUT(4, "超时"),
    ;

    private static Map<Integer, KwwCreditsStatusEnum> enumMap = Maps.newHashMap();
    static {
        enumMap.put(INIT.getSource(), INIT);
        enumMap.put(SUCCESS.getSource(), SUCCESS);
        enumMap.put(FAIL.getSource(), FAIL);
        enumMap.put(TIMEOUT.getSource(), TIMEOUT);
    }

    public static KwwCreditsStatusEnum getBySource(Integer source) {
        return enumMap.get(source);
    }

    /******************* 实例字段 ************************/
    private Integer source;

    private String desc;

    KwwCreditsStatusEnum(Integer source, String desc) {
        this.source = source;
        this.desc = desc;
    }

    public Integer getSource() {
        return source;
    }

    public String getDesc() {
        return desc;
    }
}
