package cn.com.duiba.activity.custom.center.api.enums.questionnaire;

import java.util.Objects;

/**
 * @author haojiahong
 * @date 2020-05-27
 */
public enum QuestionnaireStatusEnum {
    OFF(0, "下架"),
    ON( 1, "上架"),
    ;

    private Integer status;
    private String statusName;

    QuestionnaireStatusEnum(Integer status, String statusName) {
        this.status = status;
        this.statusName = statusName;
    }

    public Integer getStatus() {
        return status;
    }

    public String getStatusName() {
        return statusName;
    }

    public static QuestionnaireStatusEnum getByStatus(Integer status) {
        for (QuestionnaireStatusEnum value : QuestionnaireStatusEnum.values()) {
            if (Objects.equals(status, value.getStatus())) {
                return value;
            }
        }
        return null;
    }

}
