package cn.com.duiba.activity.custom.center.api.remoteservice;

import cn.com.duiba.activity.custom.center.api.dto.sndd.CrowdDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteSnddService {
    /**
     * 查询用户是否是三方新客
     * @param userId partnerUserId
     * @return
     */
    boolean isThirdNewCustomer(Long appId,String userId);

    /**
     * 查询三方人群列表
     * @return
     */
    List<CrowdDto> queryCrowdList(Long appId);

    /**
     * 用户人群校验
     * @param userId partnerUserId
     * @param crowdIdList
     * @return
     */
    boolean checkCrowdValid(Long appId,String userId, List<Long> crowdIdList);

    /**
     * 校验用户是否是新客（三方新客 & 业务新客）
     * @param consumerId
     * @return
     */
    boolean isNewCustomer(Long consumerId);

    /**
     * 校验用户是否是业务老客
     * @param consumerId
     * @return
     */
    boolean isBizOldCustomer(Long consumerId);

    /**
     * 设置用户业务老客数据
     * @param consumerId
     * @param orderId
     */
    void setBizOldData(Long consumerId, Long orderId);

    /**
     * 移除用户业务老客数据
     * @param consumerId
     * @param orderId
     */
    void removeBizOldData(Long consumerId, Long orderId);

    /**
     * 清空用户业务老客数据
     * @param consumerId
     */
    void clearBizOldData(Long consumerId);
}
