package cn.com.duiba.activity.custom.center.api.remoteservice.ccb;

import cn.com.duiba.activity.custom.center.api.dto.ccb.JhActivityWhiteHistoryDto;
import cn.com.duiba.activity.custom.center.api.enums.ccb.WhiteListRecordStatusEnum;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author JunAngLiu
 * @Title: RemoteJhActivityWhiteHistoryService
 * @Description:
 * @date 2019/10/2417:28
 */

@AdvancedFeignClient
public interface RemoteJhActivityWhiteHistoryService {

    //新增
    Long insert(JhActivityWhiteHistoryDto dto);

    /**
     * 条件查询，只返回录用成功的
     * @param managerCode
     * @param activityCode
     * @return
     */
    List<JhActivityWhiteHistoryDto> query(String managerCode, String activityCode);

    /**
     * 查询用户记录
     * @param customerPhone
     * @param activityCode
     * @return
     */
    List<JhActivityWhiteHistoryDto> queryByCustomerPhone(String customerPhone, String activityCode);

    /**
     * 查询待处理的记录，默认近四天
     */
    List<JhActivityWhiteHistoryDto> queryWaitDealRecord();

    /**
     * 按天查询待处理的记录
     * @param dates
     * @return
     */
    List<JhActivityWhiteHistoryDto> queryWaitDealRecordByDates(List<Integer> dates);

    /**
     * 更新录入状态
     * @param id
     * @param recordStatus
     * @return
     */
    Integer updateStatusById(Long id, WhiteListRecordStatusEnum recordStatus);
}
