package cn.com.duiba.activity.custom.center.api.remoteservice.cmb;

import cn.com.duiba.activity.custom.center.api.dto.cmb.CmbTransferReceiverInfoDto;
import cn.com.duiba.activity.custom.center.api.dto.cmb.CmbTransferResultDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @program: activity-custom-center
 * @description: 招行银企直连业务处理类
 * @author: Simba
 * @create: 2019-01-28 10:36
 **/
@AdvancedFeignClient
public interface RemoteCmbBankDirConnService {

    /**
     * 代发
     *
     * @param cmbTransferReceiverInfoDto
     */
    void dispense(CmbTransferReceiverInfoDto cmbTransferReceiverInfoDto) throws BizException;

    /**
     * 获取代发结果
     *
     * @param cmbTransferReceiverInfoDto
     * @return
     */
    CmbTransferResultDto getDispenseResult(CmbTransferReceiverInfoDto cmbTransferReceiverInfoDto) throws BizException;

    /**
     * 处理直接代发结果，变更流水记录状态
     *
     * @param cmbTransferReceiverInfo
     */
    void handleDispenseResult(CmbTransferReceiverInfoDto cmbTransferReceiverInfo) throws BizException;

    /**
     * 处理招行代发整个事件,该接口内部为异步执行方式
     */
    void handleCmbDispenseEvent();

}

