package cn.com.duiba.activity.custom.center.api.remoteservice.shorturl;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 短链映射服务
 */
@AdvancedFeignClient
public interface RemoteShortUrlMappingService {

  /**
   * 长链转短链
   *
   * @param longUrl 长链
   * @return <code>null</code>表示长链接生成散列码时发生冲突.否则返回正常短链URL.
   */
  String generateShortUrl(final String longUrl);

  /**
   * 长链转短链
   *
   * @param longUrl 长链
   * @return <code>null</code>表示长链接生成散列码时发生冲突.否则返回正常短链URL.
   */
  String generateShortUrl4Projectx(final String longUrl,String projectId);


  /**
   * 由hashcode获取长链
   *
   * @param hashcode 长链URL散列值
   * @return 长链URL
   */
  String getLongUrlByHashCode(final String hashcode);

  /**
   * 长链转短链(立减金使用)
   *
   * @param longUrl 长链
   * @return <code>null</code>表示长链接生成散列码时发生冲突.否则返回正常短链URL.
   */
  String generateShortUrlByCoupon(String longUrl, String prefix);

  /**
   * 由hashcode获取链接券长链
   *
   * @param hashcode 长链URL散列值
   * @return 长链URL
   */
  String getLongCouponLinkUrlByHashCode(final String hashcode);

  /**
   * 生成6位短链
   * @param longUrl
   * @return
   */
  String generateSixBitShortUrl(final String longUrl);
}
