package cn.com.duiba.activity.custom.center.api.remoteservice.tasklog;

import cn.com.duiba.activity.custom.center.api.dto.tasklog.TaskStatusLogDto;
import cn.com.duiba.activity.custom.center.api.enums.tasklog.TaskKindEnum;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author haojiahong
 * @date 2021-03-31
 */
@AdvancedFeignClient
public interface RemoteTaskStatusLogService {


    /**
     * 获取用户任务完成情况（包括每日任务和永久任务）
     *
     * @param appId
     * @param consumerId
     * @return
     */
    List<TaskStatusLogDto> getTaskList(Long appId, Long consumerId);


    /**
     * 获取用户每日任务完成情况
     *
     * @param appId
     * @param consumerId
     * @return
     */
    List<TaskStatusLogDto> getDayTaskList(Long appId, Long consumerId);

    /**
     * 获取用户永久任务完成情况
     *
     * @param appId
     * @param consumerId
     * @return
     */
    List<TaskStatusLogDto> getPermanentTaskList(Long appId, Long consumerId);

    /**
     * 判断用户今日任务是否已完成
     *
     * @return
     */
    Boolean checkDoneDayTask(Long appId, Long consumerId, TaskKindEnum taskKindEnum);

    /**
     * 判断用户永久任务是否已完成
     *
     * @param appId
     * @param consumerId
     * @param taskKindEnum
     * @return
     */
    Boolean checkDonePermanentTask(Long appId, Long consumerId, TaskKindEnum taskKindEnum);

    /**
     * 完成任务
     *
     * @param appId
     * @param consumerId
     * @param taskKindEnum
     * @param taskExtraInfo
     * @return
     */
    Boolean doneTask(Long appId, Long consumerId, TaskKindEnum taskKindEnum, Integer credits, String taskExtraInfo);


}
