/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.custom.center.api.enums;

import com.google.common.collect.ImmutableSet;

public enum DuibaPrizeTypeEnum {
    OBJECT("object", "\u5b9e\u7269"),
    ALIPAY("alipay", "\u652f\u4ed8\u5b9d"),
    QB("qb", "QQ\u5e01"),
    PHONE_BILL("phonebill", "\u8bdd\u8d39"),
    COUPON("coupon", "\u4f18\u60e0\u52b5"),
    VIRTUAL_ITEM("virtual", "\u865a\u62df\u5546\u54c1"),
    COLLECT_GOODS("collectGoods", "\u96c6\u5361"),
    THANKS("thanks", "\u8c22\u8c22\u53c2\u4e0e"),
    TRY_AGAIN("again", "\u518d\u6765\u4e00\u6b21"),
    LUCK_BAG("lucky", "\u798f\u888b");

    private String type;
    private String desc;
    private static final ImmutableSet<String> ACCESS_TO_BIZ_POOL;

    private DuibaPrizeTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static boolean isIncludeSpecialType(String type) {
        return DuibaPrizeTypeEnum.THANKS.type.equals(type) || DuibaPrizeTypeEnum.TRY_AGAIN.type.equals(type) || DuibaPrizeTypeEnum.LUCK_BAG.type.equals(type);
    }

    public static boolean isAccessToBizPoolType(String type) {
        return ACCESS_TO_BIZ_POOL.contains((Object)type);
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        ACCESS_TO_BIZ_POOL = ImmutableSet.of((Object)DuibaPrizeTypeEnum.COLLECT_GOODS.type, (Object)DuibaPrizeTypeEnum.THANKS.type, (Object)DuibaPrizeTypeEnum.TRY_AGAIN.type, (Object)DuibaPrizeTypeEnum.LUCK_BAG.type);
    }
}

