package cn.com.duiba.activity.custom.center.api.remoteservice.wanda;

import cn.com.duiba.activity.custom.center.api.dto.wandav1.distribution.DistributeDto;
import cn.com.duiba.activity.custom.center.api.dto.wandav1.distribution.WandaDisOrderDto;
import cn.com.duiba.activity.custom.center.api.paramquery.PageResult;
import cn.com.duiba.activity.custom.center.api.params.wanda.DisListParam;
import cn.com.duiba.activity.custom.center.api.params.wanda.DisOrderNoPageParam;
import cn.com.duiba.activity.custom.center.api.params.wanda.DisOrderParam;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @Description 分销服务
 * @Author bushellings
 * @Date 2024/9/11 16:23
 */
@AdvancedFeignClient
public interface RemoteDisService {

    /**
     * 分销员列表
     */
    PageResult<DistributeDto> list(DisListParam param);

    /**
     * 分销员明细
     */
    DistributeDto detail(String disNo);

    /**
     * 分页查询分销订单列表
     */
    PageResult<WandaDisOrderDto> orderListPage(DisOrderParam disOrderParam) throws BizException;

    /**
     * 查询分销订单列表
     * 无分页
     * @return
     */
    List<WandaDisOrderDto> orderList(DisOrderNoPageParam disOrderNoPageParam) throws BizException;


    /**
     * 分销员累计奖励积分
     * @param cid
     * @param status
     * @return
     */
    Integer getDisUserCredits(Long cid, Integer status) throws BizException;

    /**
     * 分销员累计奖励积分（根据disNo）
     * @param disNo
     * @param status
     * @return
     */
    Integer getDisUserCreditsByDisNo(String disNo, Integer status) throws BizException;

    /**
     * 插入分销订单
     * @param wandaDisOrderDto
     */
    void insertDisOrder(WandaDisOrderDto wandaDisOrderDto) throws BizException;


    void updateDisOrder(WandaDisOrderDto wandaDisOrderDto);

    /**
     * 根据订单id查询分销订单
     * @param orderId
     * @return {@link WandaDisOrderDto}
     */
    WandaDisOrderDto getOneByOrderId(Long orderId);
}
