package cn.com.duiba.activity.custom.center.api.remoteservice;

import cn.com.duiba.activity.custom.center.api.dto.watsons.CouponDto;
import cn.com.duiba.activity.custom.center.api.dto.watsons.CouponStatusDto;
import cn.com.duiba.activity.custom.center.api.dto.watsons.GoodsDetailDto;
import cn.com.duiba.activity.custom.center.api.dto.watsons.GoodsDetailQueryParam;
import cn.com.duiba.activity.custom.center.api.enums.watsons.WatsonsVipEnum;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2018/8/5 16:06
 */
@AdvancedFeignClient
public interface RemoteWatsonsPrizeService {

    /**
     * 查询优惠券信息
     * @param couponCode 券码
     * @return 优惠券信息
     */
    CouponStatusDto getCouponStatus(String couponCode);

    /**
     * 查询中奖结果
     * @param activityOrder
     * @return
     */
    CouponDto findByActivityOrder(String activityOrder);

    /**
     * 随机获取20条记录
     * @return 中奖信息
     */
    List<CouponDto> getRandomPrizeList();

    /**
     * 查询用户中奖记录
     * @param consumerId 用户ID
     * @return 中奖记录
     */
    List<CouponDto> findPrizeRecord(Long consumerId);

    /**
     * 获取商品详情链接
     * @param queryParam 查询参数
     * @return String 链接
     */
    String getGoodsDetailLink(GoodsDetailQueryParam queryParam) throws BizException;

    /**
     * 通过会员等级获取商品列表
     * @param vip
     * @return
     */
    List<GoodsDetailDto> getGoodsDataByLevel(WatsonsVipEnum vip) throws BizException;

}
