package cn.com.duiba.activity.custom.center.api.remoteservice.questionnaire;

import cn.com.duiba.activity.custom.center.api.dto.questionnaire.QuestionnaireContentDto;
import cn.com.duiba.activity.custom.center.api.dto.questionnaire.QuestionnaireDto;
import cn.com.duiba.activity.custom.center.api.params.questionnaire.QuestionnaireQueryParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 调查问卷管理
 *
 * @author haojiahong
 * @date 2020-05-29
 */
@AdvancedFeignClient
public interface RemoteQuestionnaireMngService {

    /**
     * 根据条件查询调查问卷
     *
     * @param param
     * @return
     */
    List<QuestionnaireDto> selectList(QuestionnaireQueryParam param);

    /**
     * 配合selectList使用，查询满足条件的记录数
     *
     * @param param
     * @return
     */
    int selectCount(QuestionnaireQueryParam param);

    /**
     * 通过问卷id查询问卷信息
     *
     * @param id 问卷id
     * @return
     */
    QuestionnaireContentDto selectById(Long id);

    /**
     * 通过name查询记录
     *
     * @param name
     * @return
     */
    QuestionnaireDto selectByName(String name);

    /**
     * 通过问卷id查询问卷记录
     *
     * @param id
     * @return
     */
    QuestionnaireDto selectByPrimaryKey(Long id);

    /**
     * 根据问卷id更新问卷基本信息
     *
     * @param pojo
     * @return
     */
    Integer updateById(QuestionnaireDto pojo);

    /**
     * 根据问卷id复制某个问卷
     *
     * @param pojo
     * @return
     */
    Integer copyById(QuestionnaireDto pojo);

}
