package cn.com.duiba.nezha.engine.api.serialization;

import cn.com.duiba.nezha.engine.api.dto.*;
import org.apache.dubbo.common.serialize.support.SerializationOptimizer;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/**
 * 注册需要序列化得类以 保证 dubbo序列化 效果达到最大
 */
public class SerializationOptimizerImpl implements SerializationOptimizer {

    @Override
    public Collection<Class> getSerializableClasses() {
        List<Class> classes = new LinkedList<Class>();
        classes.add(ReqAdvertNewDto.class);
        classes.add(ConsumerDto.class);
        classes.add(AdvertNewDto.class);
        classes.add(MaterialDto.class);
        classes.add(RequestDto.class);
        classes.add(AppDto.class);
        classes.add(AdvertActivityDto.class);
        return classes;
    }
}