package cn.com.duiba.nezha.engine.api.dto;

import lombok.Data;

import java.io.Serializable;

@Data
public class SupportAdvertInfoDto implements Serializable {

    private static final long serialVersionUID = 8178491483907929690L;

    // 扶持目标为落地页转化
    private static final Integer LOAD_CVRTYPE = 1;

    // 是否为KA扶持广告，true-扶持，false-不扶持
    private Boolean supportAdvert;

    // 每日单广告发券量，上限
    private Long planAdvertUpper = 0L;

    // 每日单广告发券量，当前值
    private Long planAdvertCur = 0L;

    // 每日单媒体发券量，上限
    private Long planAppUpper = 0L;

    // 每日单媒体发券量，当前值
    private Long planAppCur = 0L;

    // 出价扶持阈值：低值
    private Double planPriceStart = 1.0;

    // 出价扶持阈值：高值
    private Double planPriceEnd = 1.0;

    // 扶持目标类型:1=落地页转化、2=启动、3=注册
    private Integer planCvrType;

    // 扶持目标成本
    private Integer planTargetCost;

    public Integer getPlanCvrType() {

        //如果是落地页，则转为0
        if(LOAD_CVRTYPE.equals(planCvrType)){
            return 0;
        }

        return planCvrType;
    }
}
