package cn.com.duiba.nezha.engine.api.enums;

/**
 * 大禹实验结果
 */
public enum DayuArgumentsEnum {


    // ocpc弱定向优化实验的key
    TRUSTEESHIP("trusteeship", "是否开启托管"),
    PACING("pacing", "是否开启pacing"),
    OPTBASE("optBase", "是否开启底价优化"),
    NAME("name", "ocpc_name"),

    SLOT_PREFER("slotPrefer", "是否开启广告位优选定向"),
    PEOPLE_PREFER("peoplePrffer", "是否开启人群优选定向"),
    EXPAND_NAME("expandname", "expandname"),

    PEOPLE_MODEL("peopleModel", "人群定向模型ID"),
    MERGE_MODEL("mergeModel", "广告位定向模型ID"),

    //StabilityABtestEnum
    STABILITY_AB("stability_ab", "维稳AB实验"),

    ;

    // 开启
    public static final String OPEN = "1";
    // 关闭
    public static final String CLOSE = "0";

    // 广告位优选实验
    public static final String SLOT_EXP = "slotExp";
    // 人群定向实验
    public static final String PEOPLE_EXP = "peopleExp";

    private String key;

    private String desc;


    DayuArgumentsEnum(String key, String desc) {
        this.key = key;
        this.desc = desc;
    }

    public static DayuArgumentsEnum get(String key) {

        for (DayuArgumentsEnum dayuArgumentsEnum : DayuArgumentsEnum.values()) {
            if (dayuArgumentsEnum.getKey().equals(key)) {
                return dayuArgumentsEnum;
            }
        }
        return null;
    }

    public String getKey() {

        return key;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 判断是否关闭，true-关闭，false-未关闭
     * @param argumetValue 实验参数值
     * @return
     */
    public static boolean judgeClose(String argumetValue){

        return CLOSE.equals(argumetValue);
    }

    /**
     * 判断是否关闭，true-开启，false-未开启
     * @param argumetValue 实验参数值
     * @return
     */
    public static boolean judgeOpen(String argumetValue){
        return OPEN.equals(argumetValue);
    }

}
