package cn.com.duiba.nezha.engine.api.enums;

/**
 * 策略类型
 */
public enum PeoplePreferAlgEnum {

    PEOPLE_MODEL_1(1, "人群定向模型v001"),
    PEOPLE_MODEL_2(2, "人群定向模型v002"),

    ;

    // 模型ID
    private Integer type;

    private String desc;

    PeoplePreferAlgEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static PeoplePreferAlgEnum get(String type) {

        for (PeoplePreferAlgEnum pemodelEnum : PeoplePreferAlgEnum.values()) {
            if (pemodelEnum.getType().toString().equals(type)) {
                return pemodelEnum;
            }
        }
        return null;
    }

    public Integer getType() {

        return type;
    }

    public String getDesc() {
        return desc;
    }


}
